<?php

use App\Http\Controllers\Admin\Location\LocationController;
use App\Http\Controllers\FrontendController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\User\BookingController;
use Illuminate\Support\Facades\Route;

Route::get('/', [FrontendController::class, 'index'])->name('home');

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/dashboard', function () {
        if (user()->hasRole('admin')) {
            return to_route('admin.dashboard');
        } elseif (user()->hasRole('agent')) {
            return to_route('agent.dashboard');
        } elseif (user()->hasRole('user')) {
            return to_route('user.dashboard');
        }
        abort(403);
    })->name('dashboard');
    Route::get('profile/address', [ProfileController::class, 'address'])->name('profile.address');
    Route::put('profile/address', [ProfileController::class, 'addressUpdate']);
    Route::put('profile/password/{user}', [ProfileController::class, 'password'])->name('profile.password');
    Route::resource('profile', ProfileController::class);
});

Route::get('about-us', [FrontendController::class, 'about'])->name('about');
Route::get('destinations', [FrontendController::class, 'destination'])->name('destination');
Route::get('destination/{destination:slug}', [FrontendController::class, 'destinationShow'])->name('destination.show');
Route::get('packages', [FrontendController::class, 'package'])->name('package');
Route::get('package/{destination:slug}/{package:slug}', [FrontendController::class, 'packageShow'])->name('package.show');
Route::get('faqs', [FrontendController::class, 'faq'])->name('faq');
Route::get('contact-us', [FrontendController::class, 'contact'])->name('contact');
Route::post('contact-us', [FrontendController::class, 'contactStore'])->name('contact');
Route::get('blog/{blog:slug}', [FrontendController::class, 'blog'])->name('front.blog');
Route::post('subscribe', [FrontendController::class, 'subscribe'])->name('subscribe');

// Location Routes
Route::prefix('locations/search')->as('location.')->group(function () {
    Route::get('countries', [LocationController::class, 'countries'])->name('countries');
    Route::get('states', [LocationController::class, 'states'])->name('states');
    Route::get('cities', [LocationController::class, 'cities'])->name('cities');
});
// Booking Routes
Route::prefix('sslz')->as('sslz.')->group(function () {
    Route::post('success', [BookingController::class, 'success'])->name('success');
    Route::post('fail', [BookingController::class, 'fail'])->name('cancel');
    Route::post('ipn', [BookingController::class, 'ipn'])->name('ipn');
});
Route::prefix('booking')->as('booking.')->group(function () {
    Route::get('create/{package:slug?}', [BookingController::class, 'create'])->name('create');
    Route::post('session/{package:slug}', [BookingController::class, 'session'])->name('session');
    Route::post('store', [BookingController::class, 'store'])->name('store');
});
// Booking Routes

// !Route For Localizations
Route::get('locale/{locale}', function ($locale) {
    if (! in_array($locale, ['en', 'es', 'fr', 'bn', 'ar'])) {
        abort(403);
    }
    app()->setLocale($locale);
    // store the locale in session so that the middleware can register it
    session()->put('locale', $locale);

    return redirect()->back();
})->name('set-locale');

require __DIR__.'/auth.php';

Route::prefix('admin')->as('admin.')->middleware(['auth', 'verified', 'role:admin|Super Admin'])->group(function () {
    require __DIR__.'/admin.php';
});
Route::prefix('agent')->as('agent.')->middleware(['auth', 'verified', 'role:agent'])->group(function () {
    require __DIR__.'/agent.php';
});
Route::prefix('user')->as('user.')->middleware(['auth', 'verified', 'role:user'])->group(function () {
    require __DIR__.'/user.php';
});

// Impersonate User
Route::impersonate();
